<?php

namespace App\Imports;

use App\Models\Kategori;
use Illuminate\Support\Str;
use App\Models\Produk;
use App\Models\Satuan;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;

class ProdukImport implements ToCollection
{
    /**
     * @param Collection $collection
     */
    public function collection(Collection $collection)
    {
        foreach ($collection as $key => $row) {
            if ($key ==  0) continue;
            if ($key ==  1) continue;


            if ($row[0] != "") {
                $cekkd = Produk::where('kd_produk', $row[0])->first();
                $cekkt = Kategori::where('id', $row[2])->first();
                $cekst = Satuan::where('id', $row[7])->first();
                if ($cekkd != null || $cekkt == null || $cekst == null) {
                } else {

                    Produk::create([
                        'kategori_id' => $row[2],
                        'satuan_id' => $row[7],
                        'kd_produk' => $row[0],
                        'nm_produk' => $row[1],
                        'berat' => $row[3],
                        'harga_beli' => $row[4],
                        'harga_jual' => $row[5],
                        'diskon' => $row[6],
                        'ktr_produk' => "",
                        'link_produk' => strtolower($row[0]) . '-' . Str::slug($row[1]),
                        'gambar' => "",
                    ]);
                }
            }
        }
    }
}
